import time
import random
import threading
from traderion.dashboard import Dashboard

def run_test_bot(dashboard):
    """
    Run a test bot that updates the dashboard with random data.
    This is useful for testing the dashboard without connecting to the Traderion API.
    """
    print("Starting test bot...")
    
    # Initialize dashboard with a better status
    dashboard.update_core_data('status', 'Running Test')
    dashboard.update_core_data('last_action', 'Initializing test bot')
    
    # Add some initial events to show activity
    dashboard.add_bot_event('Test Bot', 'Initialized')
    dashboard.add_market_event('Test Market', 'Market initialized')
    
    # Set up initial market prices
    market_prices = {
        'bid': 100.0000,
        'ask': 101.0000,
        'open': 99.5000
    }
    dashboard.update_core_data('market_prices', market_prices)
    
    # Set up initial position
    position = {
        'amount': 0.0000,
        'pnl': 0.0000,
        'rate': 0.0000
    }
    dashboard.update_core_data('position', position)
    
    # Main loop
    try:
        counter = 0
        while True:
            counter += 1
            
            # Update market prices
            market_prices['bid'] += random.uniform(-0.5, 0.5)
            market_prices['ask'] += random.uniform(-0.5, 0.5)
            dashboard.update_core_data('market_prices', market_prices)
            
            # Update position
            position['amount'] += random.uniform(-10, 10)
            position['pnl'] += random.uniform(-5, 5)
            position['rate'] = position['amount'] * market_prices['bid']
            dashboard.update_core_data('position', position)
            
            # Add events
            if counter % 5 == 0:
                dashboard.add_bot_event('Test Event', f"Event {counter}")
                dashboard.update_core_data('last_action', f"Generated event {counter}")
            
            if counter % 10 == 0:
                dashboard.add_market_event('Market Update', f"Update {counter}")
            
            if counter % 15 == 0:
                dashboard.add_performance_metric('Test Metric', position['pnl'])
            
            # Sleep to simulate real-time updates
            time.sleep(1)
    except Exception as e:
        print(f"Test bot error: {e}")
        dashboard.update_core_data('status', f"ERROR: {e}")
        dashboard.update_core_data('last_action', 'Test bot crashed')
        dashboard.add_bot_event('Critical Error', str(e))
        raise

if __name__ == '__main__':
    """
    Entry point for the test dashboard.
    """
    print("Starting test dashboard...")
    dashboard = Dashboard(title="Traderion Test Dashboard")
    dashboard.run_dashboard(run_test_bot, (dashboard,))
